/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import com.aptana.theme.internal.TextViewerThemer;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class InvasiveThemeHijacker
extends UIJob
implements IEclipsePreferences.IPreferenceChangeListener {
    private static final String ORG_ECLIPSE_WST_JSDT_UI = "org.eclipse.wst.jsdt.ui";
    private static final String ORG_ECLIPSE_JDT_UI = "org.eclipse.jdt.ui";
    private static final String ORG_ECLIPSE_ANT_UI = "org.eclipse.ant.ui";
    private static final String ORG_ECLIPSE_PDE_UI = "org.eclipse.pde.ui";

    public InvasiveThemeHijacker() {
        super("Installing Studio theme hijacker");
        EclipseUtil.setSystemForJob((Job)this);
    }

    public synchronized IStatus runInUIThread(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.applyThemeToEclipseEditors(this.getCurrentTheme(), !this.applyToAllEditors(), (IProgressMonitor)sub.newChild(7));
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.applyThemeToConsole(this.getCurrentTheme(), (IProgressMonitor)sub.newChild(1));
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.hijackCurrentEditors(window, (IProgressMonitor)sub.newChild(2));
        sub.done();
        return Status.OK_STATUS;
    }

    private void applyThemeToConsole(Theme currentTheme, IProgressMonitor monitor) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.debug.ui");
        this.setColor(prefs, "org.eclipse.debug.ui.errorColor", currentTheme, "console.error", currentTheme.getForegroundAsRGB("console.error"));
        this.setColor(prefs, "org.eclipse.debug.ui.outColor", currentTheme, "console.output", currentTheme.getForeground());
        this.setColor(prefs, "org.eclipse.debug.ui.inColor", currentTheme, "console.input", currentTheme.getForegroundAsRGB("console.input"));
        prefs.put("org.eclipse.debug.ui.consoleBackground", StringConverter.asString((RGB)currentTheme.getBackground()));
        prefs.put("org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND", StringConverter.asString((RGB)currentTheme.getBackgroundAsRGB("markup.changed.variable")));
        if (monitor.isCanceled()) {
            return;
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    protected void setColor(IEclipsePreferences prefs, String prefKey, Theme currentTheme, String tokenName, RGB defaultColor) {
        RGB rgb = defaultColor;
        if (currentTheme.hasEntry(tokenName)) {
            rgb = currentTheme.getForegroundAsRGB(tokenName);
        }
        prefs.put(prefKey, StringConverter.asString((RGB)rgb));
    }

    private boolean applyToAllEditors() {
        return ThemePlugin.applyToAllEditors();
    }

    private void hijackCurrentEditors(IWorkbenchWindow window, IProgressMonitor monitor) {
        IEditorReference[] editorRefs;
        if (window == null || window.getActivePage() == null) {
            return;
        }
        IEditorReference[] iEditorReferenceArray = editorRefs = window.getActivePage().getEditorReferences();
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            this.hijackEditor(ref.getEditor(false));
            ++n2;
        }
    }

    private Theme getCurrentTheme() {
        return ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
    }

    private void applyThemeToEclipseEditors(Theme theme, boolean revertToDefaults, IProgressMonitor monitor) {
        Bundle wstBundle;
        IScopeContext instance = InstanceScope.INSTANCE;
        this.setHyperlinkValues(theme, instance.getNode("org.eclipse.ui.workbench"), revertToDefaults);
        this.setHyperlinkValues(theme, instance.getNode("com.aptana.theme"), revertToDefaults);
        this.setGitAndMercurialValues(theme, instance.getNode("org.eclipse.ui.workbench"), revertToDefaults);
        this.setGeneralEditorValues(theme, instance.getNode("org.eclipse.ui.texteditor"), revertToDefaults);
        this.setEditorValues(theme, instance.getNode("org.eclipse.ui.editors"), revertToDefaults);
        if (monitor.isCanceled()) {
            return;
        }
        Bundle pde = Platform.getBundle((String)ORG_ECLIPSE_PDE_UI);
        if (pde != null) {
            IEclipsePreferences pdePrefs = instance.getNode(ORG_ECLIPSE_PDE_UI);
            this.setGeneralEditorValues(theme, pdePrefs, revertToDefaults);
            this.setPDEEditorValues(theme, pdePrefs, revertToDefaults);
        }
        if (monitor.isCanceled()) {
            return;
        }
        Bundle ant = Platform.getBundle((String)ORG_ECLIPSE_ANT_UI);
        if (ant != null) {
            IEclipsePreferences antPrefs = instance.getNode(ORG_ECLIPSE_ANT_UI);
            this.setGeneralEditorValues(theme, antPrefs, revertToDefaults);
            this.setAntEditorValues(theme, antPrefs, revertToDefaults);
        }
        if (monitor.isCanceled()) {
            return;
        }
        Bundle jdt = Platform.getBundle((String)ORG_ECLIPSE_JDT_UI);
        if (jdt != null) {
            this.applyThemetoJDT(theme, revertToDefaults);
        }
        if ((wstBundle = Platform.getBundle((String)ORG_ECLIPSE_WST_JSDT_UI)) != null) {
            this.applyThemetoWST(theme, revertToDefaults);
        }
    }

    private void applyThemetoWST(Theme theme, boolean revertToDefaults) {
        this.applyToWST_JSDTEditor(theme, revertToDefaults);
        this.applyToWST_CSSEditor(theme, revertToDefaults);
        this.applyToWST_HTMLEditor(theme, revertToDefaults);
        this.applyToWST_XMLEditor(theme, revertToDefaults);
    }

    private void applyToWST_HTMLEditor(Theme theme, boolean revertToDefaults) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.wst.html.ui");
        this.setGeneralEditorValues(theme, prefs, revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.definition.tag.html", "tagBorder", revertToDefaults);
        this.setWSTToken(prefs, theme, "entity.name.tag.html", "tagName", revertToDefaults);
        this.setWSTToken(prefs, theme, "entity.other.attribute-name.html", "tagAttributeName", revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.separator.key-value.html", "tagAttributeEquals", revertToDefaults);
        this.setWSTToken(prefs, theme, "string.quoted.html", "tagAttributeValue", revertToDefaults);
        this.setWSTToken(prefs, theme, "text.html", "xmlContent", revertToDefaults);
        this.setWSTToken(prefs, theme, "comment.block.html", "commentBorder", revertToDefaults);
        this.setWSTToken(prefs, theme, "comment.block.html", "commentText", revertToDefaults);
        this.setWSTToken(prefs, theme, "constant.character.entity.html", "entityReference", revertToDefaults);
        this.setWSTToken(prefs, theme, "entity.name.tag.doctype.html", "doctypeName", revertToDefaults);
        this.setWSTToken(prefs, theme, "text.html", "doctypeExternalPubref", revertToDefaults);
        this.setWSTToken(prefs, theme, "text.html", "doctypeExtrenalSysref", revertToDefaults);
        this.setWSTToken(prefs, theme, "text.html", "doctypeExternalId", revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.definition.tag.html", "declBoder", revertToDefaults);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private void applyToWST_JSDTEditor(Theme theme, boolean revertToDefaults) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(ORG_ECLIPSE_WST_JSDT_UI);
        this.setGeneralEditorValues(theme, prefs, revertToDefaults);
        this.setToken(prefs, theme, "source.js", "java_default", revertToDefaults);
        this.setToken(prefs, theme, "comment.line.double-slash.js", "java_single_line_comment", revertToDefaults);
        this.setToken(prefs, theme, "comment.block", "java_multi_line_comment", revertToDefaults);
        this.setToken(prefs, theme, "string.quoted.double.js", "java_string", revertToDefaults);
        this.setToken(prefs, theme, "keyword", "java_keyword", revertToDefaults);
        this.setToken(prefs, theme, "keyword.operator", "java_operator", revertToDefaults);
        this.setToken(prefs, theme, "keyword.control.js", "java_keyword_return", revertToDefaults);
        this.setToken(prefs, theme, "punctuation.bracket.js", "java_bracket", revertToDefaults);
        this.setToken(prefs, theme, "keyword.other.documentation.task", "commentTaskTag", revertToDefaults);
        this.setToken(prefs, theme, "keyword.other.documentation.js", "java_doc_keyword", revertToDefaults);
        this.setToken(prefs, theme, "entity.name.tag.inline.any.html", "java_doc_tag", revertToDefaults);
        this.setToken(prefs, theme, "markup.underline.link.javadoc", "java_doc_link", revertToDefaults);
        this.setToken(prefs, theme, "comment.block.documentation.javadoc", "java_doc_default", revertToDefaults);
        this.setToken(prefs, theme, "meta.tag.documentation.js", "tagName", revertToDefaults);
        this.setSemanticToken(prefs, theme, "entity.name.function.js", "methodDeclarationName", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.js", "localVariable", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.js", "localVariableDeclaration", revertToDefaults);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private void applyToWST_CSSEditor(Theme theme, boolean revertToDefaults) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.wst.css.ui");
        this.setGeneralEditorValues(theme, prefs, revertToDefaults);
        this.setWSTToken(prefs, theme, "meta.property-name.css support.type.property-name.css", "PROPERTY_NAME", revertToDefaults);
        this.setWSTToken(prefs, theme, "entity.other.attribute-name.class.css", "CLASS", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.css", "ATTRIBUTE_VALUE", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.css", "UNIVERSAL", revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.css", "COMBINATOR", revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.terminator.rule.css", "SEMI_COLON", revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.bracket.css", "ATTRIBUTE_DELIM", revertToDefaults);
        this.setWSTToken(prefs, theme, "entity.name.tag.css", "SELECTOR", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.css", "URI", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.css", "ATTRIBUTE_NAME", revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.separator.key-value.css", "COLON", revertToDefaults);
        this.setWSTToken(prefs, theme, "entity.other.attribute-name.id.css", "ID", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.css", "NORMAL", revertToDefaults);
        this.setWSTToken(prefs, theme, "string.quoted.css", "STRING", revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.section.property-list.css", "CURLY_BRACE", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.css", "PSEUDO", revertToDefaults);
        this.setWSTToken(prefs, theme, "comment.block.css", "COMMENT", revertToDefaults);
        this.setWSTToken(prefs, theme, "support.constant.property-value.css", "PROPERTY_VALUE", revertToDefaults);
        this.setWSTToken(prefs, theme, "keyword.control.at-rule.css", "ATMARK_RULE", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.css", "ATTRIBUTE_OPERATOR", revertToDefaults);
        this.setWSTToken(prefs, theme, "support.constant.media.css", "MEDIA", revertToDefaults);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private void applyToWST_XMLEditor(Theme theme, boolean revertToDefaults) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.wst.xml.ui");
        this.setGeneralEditorValues(theme, prefs, revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.definition.tag.xml", "tagBorder", revertToDefaults);
        this.setWSTToken(prefs, theme, "entity.name.tag.xml", "tagName", revertToDefaults);
        this.setWSTToken(prefs, theme, "entity.other.attribute-name.xml", "tagAttributeName", revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.separator.key-value.xml", "tagAttributeEquals", revertToDefaults);
        this.setWSTToken(prefs, theme, "string.quoted.xml", "tagAttributeValue", revertToDefaults);
        this.setWSTToken(prefs, theme, "text.xml", "xmlContent", revertToDefaults);
        this.setWSTToken(prefs, theme, "comment.block.xml", "commentBorder", revertToDefaults);
        this.setWSTToken(prefs, theme, "comment.block.xml", "commentText", revertToDefaults);
        this.setWSTToken(prefs, theme, "constant.character.entity.xml", "entityReference", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.dtd", "doctypeName", revertToDefaults);
        this.setWSTToken(prefs, theme, "keyword.operator.dtd", "doctypeExternalPubref", revertToDefaults);
        this.setWSTToken(prefs, theme, "keyword.operator.dtd", "doctypeExtrenalSysref", revertToDefaults);
        this.setWSTToken(prefs, theme, "keyword.operator.dtd", "doctypeExternalId", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.dtd", "declBorder", revertToDefaults);
        this.setWSTToken(prefs, theme, "string.unquoted.cdata.xml", "cdataBorder", revertToDefaults);
        this.setWSTToken(prefs, theme, "string.unquoted.cdata.xml", "cdataText", revertToDefaults);
        this.setWSTToken(prefs, theme, "meta.tag.preprocessor.xml", "piBorder", revertToDefaults);
        this.setWSTToken(prefs, theme, "meta.tag.preprocessor.xml", "piContent", revertToDefaults);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private void applyThemetoJDT(Theme theme, boolean revertToDefaults) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(ORG_ECLIPSE_JDT_UI);
        this.setGeneralEditorValues(theme, prefs, revertToDefaults);
        this.setToken(prefs, theme, "string.quoted.double.java", "java_string", revertToDefaults);
        this.setToken(prefs, theme, "source.java", "java_default", revertToDefaults);
        this.setToken(prefs, theme, "keyword", "java_keyword", revertToDefaults);
        this.setToken(prefs, theme, "keyword.operator", "java_operator", revertToDefaults);
        this.setToken(prefs, theme, "keyword.control.java", "java_keyword_return", revertToDefaults);
        this.setToken(prefs, theme, "comment.line.double-slash.java", "java_single_line_comment", revertToDefaults);
        this.setToken(prefs, theme, "comment.block", "java_multi_line_comment", revertToDefaults);
        this.setToken(prefs, theme, "punctuation.bracket.java", "java_bracket", revertToDefaults);
        this.setToken(prefs, theme, "keyword.other.documentation.java", "java_doc_keyword", revertToDefaults);
        this.setToken(prefs, theme, "entity.name.tag.inline.any.html", "java_doc_tag", revertToDefaults);
        this.setToken(prefs, theme, "markup.underline.link.javadoc", "java_doc_link", revertToDefaults);
        this.setToken(prefs, theme, "comment.block.documentation.javadoc", "java_doc_default", revertToDefaults);
        this.setToken(prefs, theme, "entity.name.type.class.java", "java_type", revertToDefaults);
        this.setToken(prefs, theme, "storage.type.annotation.java", "java_annotation", revertToDefaults);
        this.setSemanticToken(prefs, theme, "entity.name.type.class.java", "class", revertToDefaults);
        this.setSemanticToken(prefs, theme, "entity.name.type.enum.java", "enum", revertToDefaults);
        this.setSemanticToken(prefs, theme, "entity.name.type.interface.java", "interface", revertToDefaults);
        this.setSemanticToken(prefs, theme, "constant.numeric.java", "number", revertToDefaults);
        this.setSemanticToken(prefs, theme, "variable.parameter.java", "parameterVariable", revertToDefaults);
        this.setSemanticToken(prefs, theme, "constant.other.java", "staticField", revertToDefaults);
        this.setSemanticToken(prefs, theme, "constant.other.java", "staticFinalField", revertToDefaults);
        this.setSemanticToken(prefs, theme, "entity.name.function.java", "methodDeclarationName", revertToDefaults);
        this.setSemanticToken(prefs, theme, "invalid.deprecated.java", "deprecatedMember", revertToDefaults);
        this.setSemanticToken(prefs, theme, "storage.type.annotation.java", "annotation", revertToDefaults);
        this.setSemanticToken(prefs, theme, "constant.other.key.java", "annotationElementReference", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "localVariable", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "field", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "staticMethodInvocation", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "inheritedMethodInvocation", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "abstractMethodInvocation", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "localVariableDeclaration", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "method", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "typeParameter", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "autoboxing", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "typeArgument", revertToDefaults);
        this.setToken(prefs, theme, "keyword.other.java-props", "pf_coloring_key", revertToDefaults);
        this.setToken(prefs, theme, "comment.line.number-sign.java-props", "pf_coloring_comment", revertToDefaults);
        this.setToken(prefs, theme, "string.java-props", "pf_coloring_value", revertToDefaults);
        this.setToken(prefs, theme, "punctuation.separator.key-value.java-props", "pf_coloring_assignment", revertToDefaults);
        this.setToken(prefs, theme, "string.interpolated.java-props", "pf_coloring_argument", revertToDefaults);
        if (!revertToDefaults) {
            prefs.put("matchingBracketsColor", StringConverter.asString((RGB)theme.getCharacterPairColor()));
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
        Font fFont = JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
        JFaceResources.getFontRegistry().put("org.eclipse.jdt.ui.editors.textfont", fFont.getFontData());
    }

    private void setGitAndMercurialValues(Theme theme, IEclipsePreferences prefs, boolean revertToDefaults) {
        if (prefs == null) {
            return;
        }
        if (revertToDefaults) {
            prefs.remove("org.eclipse.egit.ui.UncommittedChangeBackgroundColor");
            prefs.remove("org.eclipse.egit.ui.UncommittedChangeForegroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.addedForegroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.addedBackgroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.changedForegroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.changedBackgroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.removedForegroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.removedBackgroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedForegroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedBackgroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownForegroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownBackgroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictForegroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictBackgroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.IgnoredForegroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.IgnoredBackgroundColor");
        } else {
            TextAttribute changedFile = theme.getTextAttribute("markup.changed");
            TextAttribute addedFile = theme.getTextAttribute("markup.inserted");
            TextAttribute deletedFile = theme.getTextAttribute("markup.deleted");
            TextAttribute conflictFile = theme.getTextAttribute("invalid");
            prefs.put("org.eclipse.egit.ui.UncommittedChangeForegroundColor", StringConverter.asString((RGB)addedFile.getForeground().getRGB()));
            prefs.put("org.eclipse.egit.ui.UncommittedChangeBackgroundColor", StringConverter.asString((RGB)addedFile.getBackground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.addedForegroundColor", StringConverter.asString((RGB)addedFile.getForeground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.addedBackgroundColor", StringConverter.asString((RGB)addedFile.getBackground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.changedForegroundColor", StringConverter.asString((RGB)changedFile.getForeground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.changedBackgroundColor", StringConverter.asString((RGB)changedFile.getBackground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedForegroundColor", StringConverter.asString((RGB)deletedFile.getForeground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedBackgroundColor", StringConverter.asString((RGB)deletedFile.getBackground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.removedForegroundColor", StringConverter.asString((RGB)deletedFile.getForeground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.removedBackgroundColor", StringConverter.asString((RGB)deletedFile.getBackground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownForegroundColor", StringConverter.asString((RGB)theme.getForeground()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownBackgroundColor", StringConverter.asString((RGB)theme.getBackground()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictForegroundColor", StringConverter.asString((RGB)conflictFile.getForeground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictBackgroundColor", StringConverter.asString((RGB)conflictFile.getBackground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.IgnoredForegroundColor", StringConverter.asString((RGB)theme.getForeground()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.IgnoredBackgroundColor", StringConverter.asString((RGB)theme.getBackground()));
        }
    }

    private void setPDEEditorValues(Theme theme, IEclipsePreferences pdePrefs, boolean revertToDefaults) {
        if (pdePrefs == null) {
            return;
        }
        if (revertToDefaults) {
            pdePrefs.remove("editor.color.xml_comment");
            pdePrefs.remove("editor.color.instr");
            pdePrefs.remove("editor.color.string");
            pdePrefs.remove("editor.color.externalized_string");
            pdePrefs.remove("editor.color.default");
            pdePrefs.remove("editor.color.tag");
            pdePrefs.remove("editor.color.header_key");
            pdePrefs.remove("editor.color.header_value");
            pdePrefs.remove("editor.color.header_assignment");
            pdePrefs.remove("editor.color.header_osgi");
            pdePrefs.remove("editor.color.header_attributes");
        } else {
            this.setToken(pdePrefs, theme, "comment.block.xml", "editor.color.xml_comment", revertToDefaults);
            this.setToken(pdePrefs, theme, "meta.tag.preprocessor.xml", "editor.color.instr", revertToDefaults);
            this.setToken(pdePrefs, theme, "string.quoted.double.xml", "editor.color.string", revertToDefaults);
            this.setToken(pdePrefs, theme, "string.interpolated.xml", "editor.color.externalized_string", revertToDefaults);
            this.setToken(pdePrefs, theme, "text.xml", "editor.color.default", revertToDefaults);
            this.setToken(pdePrefs, theme, "entity.name.tag.xml", "editor.color.tag", revertToDefaults);
            this.setToken(pdePrefs, theme, "keyword.other.manifest", "editor.color.header_key", revertToDefaults);
            this.setToken(pdePrefs, theme, "source.manifest", "editor.color.header_value", revertToDefaults);
            this.setToken(pdePrefs, theme, "punctuation.separator.key-value.manifest", "editor.color.header_assignment", revertToDefaults);
            this.setToken(pdePrefs, theme, "keyword.other.manifest.osgi", "editor.color.header_osgi", revertToDefaults);
            this.setToken(pdePrefs, theme, "string.manifest", "editor.color.header_attributes", revertToDefaults);
        }
        try {
            pdePrefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private void setHyperlinkValues(Theme theme, IEclipsePreferences prefs, boolean revertToDefaults) {
        if (prefs == null || theme == null) {
            return;
        }
        if (revertToDefaults) {
            prefs.remove("HYPERLINK_COLOR");
            prefs.remove("ACTIVE_HYPERLINK_COLOR");
            prefs.remove("hyperlinkColor.SystemDefault");
            prefs.remove("hyperlinkColor");
        } else {
            TextAttribute editorHyperlink = theme.getTextAttribute("hyperlink");
            prefs.put("HYPERLINK_COLOR", StringConverter.asString((RGB)editorHyperlink.getForeground().getRGB()));
            JFaceResources.getColorRegistry().put("HYPERLINK_COLOR", editorHyperlink.getForeground().getRGB());
            prefs.put("ACTIVE_HYPERLINK_COLOR", StringConverter.asString((RGB)editorHyperlink.getForeground().getRGB()));
            JFaceResources.getColorRegistry().put("ACTIVE_HYPERLINK_COLOR", editorHyperlink.getForeground().getRGB());
            prefs.putBoolean("hyperlinkColor.SystemDefault", false);
            prefs.put("hyperlinkColor", StringConverter.asString((RGB)editorHyperlink.getForeground().getRGB()));
        }
    }

    private void setGeneralEditorValues(Theme theme, IEclipsePreferences prefs, boolean revertToDefaults) {
        if (prefs == null) {
            return;
        }
        if (revertToDefaults) {
            prefs.remove("AbstractTextEditor.Color.SelectionBackground");
            prefs.remove("AbstractTextEditor.Color.SelectionForeground");
            prefs.remove("AbstractTextEditor.Color.Background");
            prefs.remove("AbstractTextEditor.Color.Foreground");
            prefs.remove("currentLineColor");
        } else {
            prefs.put("AbstractTextEditor.Color.SelectionBackground", StringConverter.asString((RGB)theme.getSelectionAgainstBG()));
            prefs.put("AbstractTextEditor.Color.SelectionForeground", StringConverter.asString((RGB)theme.getForeground()));
            prefs.put("AbstractTextEditor.Color.Background", StringConverter.asString((RGB)theme.getBackground()));
            prefs.put("AbstractTextEditor.Color.Foreground", StringConverter.asString((RGB)theme.getForeground()));
            prefs.put("currentLineColor", StringConverter.asString((RGB)theme.getLineHighlightAgainstBG()));
        }
        prefs.putBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault", revertToDefaults);
        prefs.putBoolean("AbstractTextEditor.Color.Background.SystemDefault", revertToDefaults);
        prefs.putBoolean("AbstractTextEditor.Color.Foreground.SystemDefault", revertToDefaults);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private void setEditorValues(Theme theme, IEclipsePreferences prefs, boolean revertToDefaults) {
        if (revertToDefaults) {
            prefs.remove("occurrenceIndicationColor");
            prefs.remove("writeOccurrenceIndicationColor");
            prefs.remove("currentIPColor");
            prefs.remove("secondaryIPColor");
            prefs.putBoolean("AbstractTextEditor.Color.Background.SystemDefault", true);
            prefs.remove("AbstractTextEditor.Color.Background");
            prefs.putBoolean("AbstractTextEditor.Color.Foreground.SystemDefault", true);
            prefs.remove("AbstractTextEditor.Color.Foreground");
            prefs.putBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault", true);
            prefs.remove("AbstractTextEditor.Color.SelectionBackground");
            prefs.putBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault", true);
            prefs.remove("AbstractTextEditor.Color.SelectionForeground");
            prefs.remove("currentLineColor");
        } else {
            prefs.putBoolean("AbstractTextEditor.Color.Background.SystemDefault", false);
            prefs.put("AbstractTextEditor.Color.Background", StringConverter.asString((RGB)theme.getBackground()));
            prefs.putBoolean("AbstractTextEditor.Color.Foreground.SystemDefault", false);
            prefs.put("AbstractTextEditor.Color.Foreground", StringConverter.asString((RGB)theme.getForeground()));
            prefs.putBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault", false);
            prefs.put("AbstractTextEditor.Color.SelectionBackground", StringConverter.asString((RGB)theme.getSelectionAgainstBG()));
            prefs.putBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault", false);
            prefs.put("AbstractTextEditor.Color.SelectionForeground", StringConverter.asString((RGB)theme.getForeground()));
            prefs.put("currentLineColor", StringConverter.asString((RGB)theme.getLineHighlightAgainstBG()));
            prefs.put("occurrenceIndicationColor", StringConverter.asString((RGB)theme.getSelectionAgainstBG()));
            prefs.put("writeOccurrenceIndicationColor", StringConverter.asString((RGB)theme.getSelectionAgainstBG()));
            prefs.put("currentIPColor", StringConverter.asString((RGB)theme.getBackgroundAsRGB("meta.diff.header")));
            prefs.put("secondaryIPColor", StringConverter.asString((RGB)theme.getBackgroundAsRGB("meta.diff.header")));
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private void setAntEditorValues(Theme theme, IEclipsePreferences prefs, boolean revertToDefaults) {
        if (prefs == null) {
            return;
        }
        if (revertToDefaults) {
            prefs.remove("org.eclipse.ant.ui.commentsColor");
            prefs.remove("org.eclipse.ant.ui.processingInstructionsColor");
            prefs.remove("org.eclipse.ant.ui.constantStringsColor");
            prefs.remove("org.eclipse.ant.ui.textColor");
            prefs.remove("org.eclipse.ant.ui.tagsColor");
            prefs.remove("org.eclipse.ant.ui.dtdColor");
        } else {
            this.setToken(prefs, theme, "comment.block.xml.ant", "org.eclipse.ant.ui.commentsColor", revertToDefaults);
            this.setToken(prefs, theme, "meta.tag.preprocessor.xml.ant", "org.eclipse.ant.ui.processingInstructionsColor", revertToDefaults);
            this.setToken(prefs, theme, "string.quoted.double.xml.ant", "org.eclipse.ant.ui.constantStringsColor", revertToDefaults);
            this.setToken(prefs, theme, "text.xml.ant", "org.eclipse.ant.ui.textColor", revertToDefaults);
            this.setToken(prefs, theme, "entity.name.tag.target.xml.ant", "org.eclipse.ant.ui.tagsColor", revertToDefaults);
            this.setToken(prefs, theme, "meta.tag.preprocessor.xml.ant", "org.eclipse.ant.ui.dtdColor", revertToDefaults);
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private void setToken(IEclipsePreferences prefs, Theme theme, String ourTokenType, String jdtToken, boolean revertToDefaults) {
        if (revertToDefaults) {
            prefs.remove(jdtToken);
            prefs.remove(String.valueOf(jdtToken) + "_bold");
            prefs.remove(String.valueOf(jdtToken) + "_italic");
            prefs.remove(String.valueOf(jdtToken) + "_underline");
            prefs.remove(String.valueOf(jdtToken) + "_strikethrough");
        } else {
            TextAttribute attr = theme.getTextAttribute(ourTokenType);
            prefs.put(jdtToken, StringConverter.asString((RGB)attr.getForeground().getRGB()));
            prefs.putBoolean(String.valueOf(jdtToken) + "_bold", (attr.getStyle() & 1) != 0);
            prefs.putBoolean(String.valueOf(jdtToken) + "_italic", (attr.getStyle() & 2) != 0);
            prefs.putBoolean(String.valueOf(jdtToken) + "_underline", (attr.getStyle() & 0x40000000) != 0);
            prefs.putBoolean(String.valueOf(jdtToken) + "_strikethrough", (attr.getStyle() & 0x20000000) != 0);
        }
    }

    private void setWSTToken(IEclipsePreferences prefs, Theme theme, String ourEquivalentScope, String prefKey, boolean revertToDefaults) {
        if (revertToDefaults) {
            prefs.remove(prefKey);
        } else {
            TextAttribute attr = theme.getTextAttribute(ourEquivalentScope);
            boolean bold = (attr.getStyle() & 1) != 0;
            boolean italic = (attr.getStyle() & 2) != 0;
            boolean strikethrough = (attr.getStyle() & 0x20000000) != 0;
            boolean underline = (attr.getStyle() & 0x40000000) != 0;
            StringBuilder value = new StringBuilder();
            value.append(Theme.toHex(attr.getForeground().getRGB()));
            value.append('|');
            value.append(Theme.toHex(attr.getBackground().getRGB()));
            value.append('|');
            value.append(bold);
            value.append('|');
            value.append(italic);
            value.append('|');
            value.append(strikethrough);
            value.append('|');
            value.append(underline);
            prefs.put(prefKey, value.toString());
        }
    }

    private void setSemanticToken(IEclipsePreferences prefs, Theme theme, String ourTokenType, String jdtToken, boolean revertToDefaults) {
        String prefix = "semanticHighlighting.";
        jdtToken = String.valueOf(prefix) + jdtToken;
        if (revertToDefaults) {
            prefs.remove(String.valueOf(jdtToken) + ".color");
            prefs.remove(String.valueOf(jdtToken) + ".bold");
            prefs.remove(String.valueOf(jdtToken) + ".italic");
            prefs.remove(String.valueOf(jdtToken) + ".underline");
            prefs.remove(String.valueOf(jdtToken) + ".strikethrough");
            prefs.remove(String.valueOf(jdtToken) + ".enabled");
        } else {
            TextAttribute attr = theme.getTextAttribute(ourTokenType);
            prefs.put(String.valueOf(jdtToken) + ".color", StringConverter.asString((RGB)attr.getForeground().getRGB()));
            prefs.putBoolean(String.valueOf(jdtToken) + ".bold", (attr.getStyle() & 1) != 0);
            prefs.putBoolean(String.valueOf(jdtToken) + ".italic", (attr.getStyle() & 2) != 0);
            prefs.putBoolean(String.valueOf(jdtToken) + ".underline", (attr.getStyle() & 0x40000000) != 0);
            prefs.putBoolean(String.valueOf(jdtToken) + ".strikethrough", (attr.getStyle() & 0x20000000) != 0);
            prefs.putBoolean(String.valueOf(jdtToken) + ".enabled", true);
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals("apply_to_all_editors") || event.getKey().equals("THEME_CHANGED")) {
            this.cancel();
            this.schedule();
        }
    }

    private void overrideSelectionColor(AbstractTextEditor editor) {
        try {
            if (Class.forName("com.aptana.editor.common.extensions.IThemeableEditor").isInstance(editor)) {
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ISourceViewer sourceViewer = null;
        try {
            Method m = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            m.setAccessible(true);
            sourceViewer = (ISourceViewer)m.invoke((Object)editor, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sourceViewer == null || sourceViewer.getTextWidget() == null) {
            return;
        }
        new TextViewerThemer((ITextViewer)sourceViewer).apply();
    }

    private void hijackEditor(IEditorPart part) {
        if (!this.applyToAllEditors()) {
            return;
        }
        if (part instanceof AbstractTextEditor) {
            this.overrideSelectionColor((AbstractTextEditor)part);
        }
    }

    public void apply() {
        if (this.applyToAllEditors()) {
            this.schedule();
        }
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.theme");
        prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void dispose() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.theme");
        prefs.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }
}

